function [] = ordinalize(varargin)
%This function ask you to open up a template file with ordinals, takes the
%ordinals and then applies it to all of the other files selected
%Synatax:   [] = ordinalize('dir1','c:\...','files','syn.csv','mode',1)
%Input:     'path1' = the directory where the files are
%           'file1' = summary file 1
%           'path2' =  the directory of the second file.
%           'file2' = summary file 2
%           'filter' = filter for distance, default  = 0 or off
%Output:    none
[path1,file1,path2,file2,filter,flt_col,thresh] = parse(varargin);  %parse the input

%open the first file
ordfile = single(dlmread([path1,file1],',',1,0));    %open the file
ordinals = ordfile(:,end);  %grab the ordinals, the last column

%Now append the ordinals
mkdir(path2,'ordinalized')
for i = 1:size(file2,2)      %combine the raw data into a single file
    data_tmp = single(dlmread([path2,file2{i}],',',1,0));    %open the file
    data_tmp = horzcat(data_tmp,ordinals);  %append ordinals
    %now filter the dataset for distance
    if filter
        dist_tmp = data_tmp(:,flt_col);
        rmv_idx = find(dist_tmp>thresh);    %find the numbers above threshold
        data_tmp(rmv_idx,1:end-1) = nan;   %get gone
    end
    sav2csv(data_tmp,[file2{i}],[path2,'ordinalized']);   
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [path1,file1,path2,file2,filter,flt_col,thresh] = parse(input)

path1 = [];
file1 = [];
path2 = [];
file2 = [];
filter = 0;
flt_col = 4;
thresh = 5;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'path1'
                    path1 = input{1,i+1};
                case 'file1'
                    file1 = input{1,i+1};
                case 'path2'
                    path2 = input{1,i+1};
                case 'file2'
                    file2 = input{1,i+1};
                case 'filter'
                    filter = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

if isempty(path1)||isempty(file1)   %get files and directory
    [file1,path1,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open ordinal file','Multiselect','off');
end
if isempty(path2)||isempty(file2)   %get files and directory
    [file2,path2,filterindex] = uigetfile2b({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open target files','Multiselect','on');
end
if ~iscell(file2)
    file2 = {file2};
end